<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use VM\ApiBundle\Entity\BankService;
use VM\ApiBundle\Entity\BankServiceOptions;
use VM\ApiBundle\Entity\CreatorStages;
use VM\ApiBundle\Entity\CreatorStagesParts;
use VM\ApiBundle\Entity\CreatorStagesSteps;
use VM\ApiBundle\Entity\UserCompanyRoleTypes;


class LoadBankService extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    private $bankService = array(
        array(
            'name' => 'Rachunek bieżący',
            'symbol' => 'CURRENT_ACCOUNT',
            'step_index' => 1,
            'options' => array(
                array(
                    'name' => 'AVISTA',
                    'description' => '',
                    'flags' => 'RB', // oznaczamy domyślnie zkładany
                    'cost' => 0,
                    'percent' => 0,
                    'duration' => 0,
                    'wibor' => false
                ),
                array(
                    'name' => 'ROR',
                    'description' => '',
                    'flags' => '',
                    'cost' => 1200,
                    'percent' => 0.5,
                    'duration' => 0,
                    'wibor' => false
                )
            )
        ),
        array(
            'name' => 'Kredyt',
            'symbol' => 'CREDIT',
            'step_index' => 2,
            'options' => array(
                array(
                    'name' => 'Kredyt na zakup wyposażenia',
                    'description' => '',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 4,
                    'duration' => 4,
                    'wibor' => false
                ),
                array(
                    'name' => 'Kredyt na zakup wyposażenia',
                    'description' => '',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 1,
                    'duration' => 3,
                    'wibor' => true
                )
            )
        ),
        array(
            'name' => 'Lokata',
            'symbol' => 'INVESTMENT',
            'step_index' => 3,
            'options' => array(
                array(
                    'name' => 'Lokata na 1 rok',
                    'description' => '0% odsetek za zerwanie lokaty przed terminem',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 1,
                    'duration' => 1,
                    'wibor' => true
                ),
                array(
                    'name' => 'Lokata na 2 lata',
                    'description' => '0% odsetek za zerwanie lokaty przed terminem',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 2,
                    'duration' => 2,
                    'wibor' => true
                ),
                array(
                    'name' => 'Lokata na 3 lata',
                    'description' => '0% odsetek za zerwanie lokaty przed terminem',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 3,
                    'duration' => 3,
                    'wibor' => true
                )
                ,array(
                    'name' => 'Lokata na 4 lata',
                    'description' => '0% odsetek za zerwanie lokaty przed terminem',
                    'isValue' => true,
                    'cost' => 0,
                    'percent' => 4,
                    'duration' => 4,
                    'wibor' => false
                )
            )
        ),
        array(
            'name' => 'Kredyt obrotowy',
            'symbol' => 'REVOLVING_LOAN',
            'step_index' => 4,
            'options' => array(
                array(
                    'name' => 'obrotowy - WIBOR + 8%',
                    'description' => 'odsetki od wykorzystanej kwoty kredytu',
                    'isValue' => true,
                    'flags' => 'O',
                    'cost' => 0,
                    'percent' => 8,
                    'duration' => 0,
                    'wibor' => true
                )
                ,array(
                    'name' => 'obrotowy - 13%',
                    'description' => 'odsetki od wykorzystanej kwoty kredytu',
                    'isValue' => true,
                    'flags' => 'O',
                    'cost' => 0,
                    'percent' => 13,
                    'duration' => 0,
                    'wibor' => false
                )
            )
        ),
    );

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;

    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;

        foreach($this->bankService as $bankServiceData)
        {
            $BankService = new BankService();

            $BankService->setName($bankServiceData['name']);
            $BankService->setSymbol($bankServiceData['symbol']);
            $BankService->setStepIndex($bankServiceData['step_index']);
            $EntityManager->persist($BankService);

            foreach($bankServiceData['options'] as $option)
            {
                $BankServiceOptions = new BankServiceOptions();

                $BankServiceOptions->setName($option['name']);
                $BankServiceOptions->setBankService($BankService);
                if(isset($option['isValue']))
                {
                    $BankServiceOptions->setIsValue($option['isValue']);
                }
                if(isset($option['flags']))
                {
                    $BankServiceOptions->setFlags($option['flags']);
                }
                $BankServiceOptions->setCost($option['cost']);
                $BankServiceOptions->setPercent($option['percent']);
                $BankServiceOptions->setDuration($option['duration']);
                $BankServiceOptions->setDescription($option['description']);
                $BankServiceOptions->setWibor($option['wibor']);
                $EntityManager->persist($BankServiceOptions);
            }
        }

        $EntityManager->flush();
        $this->importWibor();
    }

    public function importWibor()
    {
        $importWibor = $this->container->get('import_wibor');
        return $importWibor->import();
    }

    public function getOrder()
    {
        return 30;
    }
}